require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );

xSpacing = 179;
xBase = 34;
yBase = 246;

MakeDialog{
    name = "upsell_screen",
    
    VUpsellWindow{
        w = 800,
        h = 600,
        image = "ui/backgrounds/worldmap",
        
	    ------------------------------------------------Button Trim pieces
        Bitmap{
	        x = 280,
	        y = 528,
	        image = "ui/buttons/button_trim",
	        mask = "ui/buttons/button_trim.mask",
	    },
	    Bitmap{
	        x = 436,
	        y = 528,
	        hflip = true,
	        image = "ui/buttons/button_trim",
	        mask = "ui/buttons/button_trim.mask",
	    },
		
	    ------------------------------------------------Header gem
	    Bitmap{
	        name = "worldmap_gem",
	        image = "ui/map/gem_story",
	    },
	    ------------------------------------------------Header text
	    Text{
		    x = 3, y = 57,
		    w = kMax, h = 75,
		    flags = kVAlignCenter + kHAlignCenter,
		    font = 	{edwardian_medium, 38, ShadowColor },
		    label = "upsell_header",
	    },
	    Text{
		    x = 0, y = 54,
		    w = kMax, h = 75,
		    flags = kVAlignCenter + kHAlignCenter,
		    font = 	{edwardian_medium, 38, Color(243, 226, 196) },
		    label = "#<outline color='545050' size='1'>"..GetString('upsell_header').."</outline>",
	    },
	    ------------------------------------------------Zeppelin
	    VObjectWindow{
	        x = 0,
	        y = 0,
	        w = kMax,
	        h = kMax,
	        objects = {
	            zeppelin = {
	                baseDir = "ui/upsell/",
	                x = -500,
	                y = 150,
	                assets = {
	                    base = {
	                        { state = "default", file="upsell_zeppelin" },
	                    },
	                },
	                children = {
	                    smoke = {
	                        continuous = true,
	                        assets = {
	                            base = {
	                                {state="default", file="anim_puff"},
	                            },
	                        },
	                    }
	                },
	                text = {
	                    date = {
	                        x = 70,
	                        y = 72,
	                        w = 110,
	                        h = 16,
	                        rotation = {0, 0, -3.0},
	                        font = {edwardian_medium, 15, Color(253,242,236) },
	                        flags = kHAlignCenter + kVAlignCenter,
	                        label = "upsell_choc_3_date",
	                    },
	                },
	                effects = {
	                    zeppelin_fly = {
	                        type = "move",
	                        x = 1500,
	                        y = 150,
	                        time = 20000,
	                    },
	                },
	            },
	        },
	    },
	    ------------------------------------------------Game Buttons
	    Button{
	        name = "upsellbutton1",
	        x = xBase,
	        y = yBase,
	        graphics = {"ui/upsell/upsell_button_up", "ui/upsell/upsell_button_down", "ui/upsell/upsell_button_up"},
		    
	        SelectLayer(0),
	        Bitmap{
	            image = "ui/upsell/logo_chocolatier",
	        },
	        SelectLayer(2),
	        Bitmap{
	            image = "ui/upsell/logo_chocolatier",
	        },
	        SelectLayer(1),
	        Bitmap{
	            y = 4,
	            image = "ui/upsell/logo_chocolatier",
	        },
	        command =
	            function()
		            LaunchGameLink(0);
	            end
	    },
	    Button{
	        name = "upsellbutton2",
	        x = xBase + xSpacing*1,
	        y = yBase,
	        graphics = {"ui/upsell/upsell_button_up", "ui/upsell/upsell_button_down", "ui/upsell/upsell_button_up"},
		    
	        SelectLayer(0),
	        Bitmap{
	            image = "ui/upsell/logo_chocolate_chase",
	        },
	        SelectLayer(2),
	        Bitmap{
	            image = "ui/upsell/logo_chocolate_chase",
	        },
	        SelectLayer(1),
	        Bitmap{
	            y = 4,
	            image = "ui/upsell/logo_chocolate_chase",
	        },
	        command =
	            function()
		            LaunchGameLink(1);
	            end
	    },
	    Button{
	        name = "upsellbutton3",
	        x = xBase + xSpacing*2,
	        y = yBase,
	        graphics = {"ui/upsell/upsell_button_up", "ui/upsell/upsell_button_down", "ui/upsell/upsell_button_up"},
		    
	        SelectLayer(0),
	        Bitmap{
	            image = "ui/upsell/logo_chocolatier2",
	        },
	        SelectLayer(2),
	        Bitmap{
	            image = "ui/upsell/logo_chocolatier2",
	        },
	        SelectLayer(1),
	        Bitmap{
	            y = 4,
	            image = "ui/upsell/logo_chocolatier2",
	        },
	        command =
	            function()
		            LaunchGameLink(2);
	            end
	    },
	    Button{
	        name = "upsellbutton4",
	        x = xBase + xSpacing*3,
	        y = yBase,
	        graphics = {"ui/upsell/upsell_button_up"},
	        --[[graphics = {"ui/upsell/upsell_button_up", "ui/upsell/upsell_button_down", "ui/upsell/upsell_button_up"},
		    
	        SelectLayer(0),
	        Bitmap{
	            image = "ui/upsell/logo_chocolatier3",
	        },
	        SelectLayer(2),
	        Bitmap{
	            image = "ui/upsell/logo_chocolatier3",
	        },
	        SelectLayer(1),
	        Bitmap{
	            y = 4,
	            image = "ui/upsell/logo_chocolatier3",
	        },]]
	        SelectLayer(-1),
	        Bitmap{
	            image = "ui/upsell/logo_chocolatier3",
	        },
	        Text{
	            x = 37,
	            y = 145,
	            w = 126,
	            h = 20,
	            font = {edwardian_medium, 16, Color( 129, 39, 27 ) },
	            flags = kHAlignCenter + kVAlignCenter,
	            label = "upsell_choc_3_date",
	        },
	        command =
	            function()
		            --LaunchGameLink(3);
	            end
	    },
		
	    ------------------------------------------------Back Button
	    SetStyle(CSMMLargeOvalButtonStyle),
	    Button{
	        name = "btn_back",
	        x = kCenter,
	        y = 600 - 79,
	        command =
	            function()
	                PostMessage( CreateNamedMessage( kFadeToBlack, "CloseWindow();PostMessage( CreateNamedMessage( kFadeFromBlack, '' ) );" ) );
	            end,
		        
	        Text{
	            w = kMax,
	            h = kMax - 6,
	            font = {edwardian_medium, 24, WhiteColor},
	            flags = kHAlignCenter + kVAlignCenter,
	            label = "app_back",
	        }
	    }
    },
}
SetupUpsell();
PostMessage( CreateNamedMessage( kFadeFromBlack, "" ) );